"use client";

import { useState, useEffect } from "react";
import {
  Dialog,
  DialogContent,
  DialogHeader,
  DialogTitle,
  DialogDescription,
} from "@/components/ui/dialog";
import { Button } from "@/components/ui/button";
import { MessageCircle } from "lucide-react";

export function ExitIntentPopup({ whatsAppLink }: { whatsAppLink: string }) {
  const [isOpen, setIsOpen] = useState(false);

  useEffect(() => {
    const handleMouseOut = (e: MouseEvent) => {
      if (
        e.clientY <= 0 ||
        e.clientX <= 0 ||
        e.clientX >= window.innerWidth ||
        e.clientY >= window.innerHeight
      ) {
        const alreadyShown = sessionStorage.getItem("exitIntentPopupShown");
        if (!alreadyShown) {
          setIsOpen(true);
          sessionStorage.setItem("exitIntentPopupShown", "true");
        }
      }
    };

    const timer = setTimeout(() => {
      const alreadyShown = sessionStorage.getItem("exitIntentPopupShown");
      if (!alreadyShown) {
        setIsOpen(true);
        sessionStorage.setItem("exitIntentPopupShown", "true");
      }
    }, 3000); 

    document.addEventListener("mouseout", handleMouseOut);

    return () => {
      clearTimeout(timer);
      document.removeEventListener("mouseout", handleMouseOut);
    };
  }, []);

  return (
    <Dialog open={isOpen} onOpenChange={setIsOpen}>
      <DialogContent className="sm:max-w-[425px]">
        <DialogHeader>
          <DialogTitle className="font-headline text-2xl text-center">Don’t Miss Out!</DialogTitle>
          <DialogDescription className="text-center pt-2">
            Join the WhatsApp group now to get course updates, special offers, and connect with fellow learners.
          </DialogDescription>
        </DialogHeader>
        <div className="py-4">
          <Button asChild className="w-full" size="lg">
            <a href={whatsAppLink} target="_blank" rel="noopener noreferrer">
              <MessageCircle className="mr-2 h-4 w-4" /> Join WhatsApp Group
            </a>
          </Button>
        </div>
      </DialogContent>
    </Dialog>
  );
}
